/****** Object:  Table [dbo].[EST_NF_ENT_IT_ACERTO_CUSTO]    Script Date: 24/09/2015 11:00:24 ******/
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
GO
IF  NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[EST_NF_ENT_IT_ACERTO_CUSTO]') 
					AND type in (N'U'))
BEGIN

	CREATE TABLE [dbo].[EST_NF_ENT_IT_ACERTO_CUSTO](
		[CD_EMP] [int] NOT NULL,
		[CD_FILIAL] [int] NOT NULL,
		[CD_NF] [int] NOT NULL,
		[CD_IMP] [int] NOT NULL,
		[DT_ENT_NF] [datetime] NOT NULL,
		[CD_PROD] [int] NOT NULL,
		[QT_AJUSTE] [money] NULL,
		[VLR_AJUSTE] [money] NOT NULL,
		[TP_AJUSTE] [int] NOT NULL,
		[CD_USU] [int] NOT NULL,
		[DT_CAD] [datetime] NOT NULL,
	 CONSTRAINT [PK_EST_NF_ENT_IT_ACERTO_CUSTO] PRIMARY KEY CLUSTERED 
	(
		[DT_ENT_NF] ASC,
		[CD_PROD] ASC,
		[CD_IMP] ASC,
		[CD_NF] ASC,
		[CD_FILIAL] ASC,
		[CD_EMP] ASC
	
	)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, 
		ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
	) ON [PRIMARY]

	ALTER TABLE [dbo].[EST_NF_ENT_IT_ACERTO_CUSTO] ADD  CONSTRAINT [DF_EST_NF_ENT_IT_ACERTO_CUSTO_CD_EMP]		DEFAULT ((0)) FOR [CD_EMP]
	ALTER TABLE [dbo].[EST_NF_ENT_IT_ACERTO_CUSTO] ADD  CONSTRAINT [DF_EST_NF_ENT_IT_ACERTO_CUSTO_CD_FILIAL]	DEFAULT ((0)) FOR [CD_FILIAL]
	ALTER TABLE [dbo].[EST_NF_ENT_IT_ACERTO_CUSTO] ADD  CONSTRAINT [DF_EST_NF_ENT_IT_ACERTO_CUSTO_CD_IMP]	DEFAULT ((0)) FOR [CD_IMP]
	ALTER TABLE [dbo].[EST_NF_ENT_IT_ACERTO_CUSTO] ADD  CONSTRAINT [DF_EST_NF_ENT_IT_ACERTO_CUSTO_CD_NF]		DEFAULT ((0)) FOR [CD_NF]
	ALTER TABLE [dbo].[EST_NF_ENT_IT_ACERTO_CUSTO] ADD  CONSTRAINT [DF_EST_NF_ENT_IT_ACERTO_CUSTO_CD_PROD]		DEFAULT ((0)) FOR [CD_PROD]
	ALTER TABLE [dbo].[EST_NF_ENT_IT_ACERTO_CUSTO] ADD  CONSTRAINT [DF_EST_NF_ENT_IT_ACERTO_CUSTO_QT_AJUSTE]	DEFAULT ((0)) FOR [QT_AJUSTE]
	ALTER TABLE [dbo].[EST_NF_ENT_IT_ACERTO_CUSTO] ADD  CONSTRAINT [DF_EST_NF_ENT_IT_ACERTO_CUSTO_VLR_AJUSTE]   DEFAULT ((0)) FOR [VLR_AJUSTE]
	ALTER TABLE [dbo].[EST_NF_ENT_IT_ACERTO_CUSTO] ADD  CONSTRAINT [DF_EST_NF_ENT_IT_ACERTO_CUSTO_TP_AJUSTE]	DEFAULT ((0)) FOR [TP_AJUSTE]
	ALTER TABLE [dbo].[EST_NF_ENT_IT_ACERTO_CUSTO] ADD  CONSTRAINT [DF_EST_NF_ENT_IT_ACERTO_CUSTO_CD_USU]		DEFAULT ((0)) FOR [CD_USU]

	ALTER TABLE [dbo].[EST_NF_ENT_IT_ACERTO_CUSTO]  WITH CHECK ADD  
		CONSTRAINT [FK_EST_NF_ENT_IT_ACERTO_CUSTO_EST_NF_ENT_IT] 
		FOREIGN KEY(CD_EMP, CD_FILIAL, CD_NF, CD_PROD)
	REFERENCES [dbo].[EST_NF_ENT_IT] (CD_EMP, CD_FILIAL, CD_NF, CD_PROD)
	ON DELETE CASCADE

	ALTER TABLE [dbo].[EST_NF_ENT_IT_ACERTO_CUSTO] 
		CHECK CONSTRAINT [FK_EST_NF_ENT_IT_ACERTO_CUSTO_EST_NF_ENT_IT] 

END


